<?php
// Checks how {{Meta}} works.

$src = '
{{meta: str="v a, l", 1=2, flag, arr=1, arr[]=item, ar2[]=1, hash[key], hash[key2]=val, a], a[, a[]}}
{{meta: ar2[]=str; meta: ar2[]=st2}}
';

  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<em class="format-error">{{Meta}} cannot add an element to "arr" – "arr" must be an array but it is \'1\'.</em><em class="format-error">Name of {{Meta}} property "a]" has a "]" bracket but no maching "[".</em>
';

$expectedMeta = array('str' => 'v a, l', 1 => '2', 'flag' => true, 'arr' => '1',
                      'ar2' => array('1', 'str', 'st2'), 'hash' => array('key' => true,
                      'key2' => 'val'), 'a[' => true, 'a' => array(true));

  TestEquality(trim($html), trim($expectedHTML));
  TestEquality($doc->meta, $expectedMeta);
